/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.Version;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class Info
implements Cloneable {
    protected Version cryptokiVersion_;
    protected String manufacturerID_;
    protected String libraryDescription_;
    protected Version libraryVersion_;

    protected Info(CK_INFO cK_INFO) {
        if (cK_INFO == null) {
            throw new NullPointerException("Argument \"ckInfo\" must not be null.");
        }
        this.cryptokiVersion_ = new Version(cK_INFO.cryptokiVersion);
        this.manufacturerID_ = new String(cK_INFO.manufacturerID);
        this.libraryDescription_ = new String(cK_INFO.libraryDescription);
        this.libraryVersion_ = new Version(cK_INFO.libraryVersion);
    }

    public Object clone() {
        Info info;
        try {
            info = (Info)super.clone();
            info.cryptokiVersion_ = (Version)this.cryptokiVersion_.clone();
            info.libraryVersion_ = (Version)this.libraryVersion_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return info;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Info) {
            Info info = (Info)object;
            bl = this == info || this.cryptokiVersion_.equals(info.cryptokiVersion_) && this.manufacturerID_.equals(info.manufacturerID_) && this.libraryDescription_.equals(info.libraryDescription_) && this.libraryVersion_.equals(info.libraryVersion_);
        }
        return bl;
    }

    public Version getCryptokiVersion() {
        return this.cryptokiVersion_;
    }

    public String getLibraryDescription() {
        return this.libraryDescription_;
    }

    public Version getLibraryVersion() {
        return this.libraryVersion_;
    }

    public String getManufacturerID() {
        return this.manufacturerID_;
    }

    public int hashCode() {
        return this.cryptokiVersion_.hashCode() ^ this.manufacturerID_.hashCode() ^ this.libraryDescription_.hashCode() ^ this.libraryVersion_.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cryptoki Version: ");
        stringBuffer.append(this.cryptokiVersion_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("ManufacturerID: ");
        stringBuffer.append(this.manufacturerID_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Library Description: ");
        stringBuffer.append(this.libraryDescription_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Library Version: ");
        stringBuffer.append(this.libraryVersion_);
        return stringBuffer.toString();
    }
}

